﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.TBI;

public partial class AdminListInactive : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldRegistryName.Value = Helpers.GetConfigEntry("Registry");
    }

    public override string MenuItemName()
    {
        return "List Inactive";
    }

    public override string AppObjectCode()
    {
        return "TBI ADMIN LIST INACTIVE RECORDS";
    }

    public override string TopMenuName()
    {
        return "Administration";
    }

    protected void btnSelect_Click(object sender, EventArgs e)
    {
        try
        {
            int trauma_id = 0;
            Button btn = sender as Button;
            if (btn != null)
            {
                if (Int32.TryParse(btn.CommandArgument, out trauma_id))
                {
                    Response.Redirect(string.Format("PolyTraumaEntry.aspx?id={0}", trauma_id), false);
                }
            }
        }
        catch //(Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, "AdminListInactive", "100003", "btnSelect_Click()");
        }
    }

    protected void btnRestore_Click(object sender, EventArgs e)
    {
        try
        {
            int trauma_id = 0;
            Button btn = sender as Button;
            if (btn != null)
            {
                if (Int32.TryParse(btn.CommandArgument, out trauma_id))
                {
                    PolyTraumaEntriesManager PolyTraumaManager = new PolyTraumaEntriesManager();

                    TBI_POLYTRAUMA polyTraumEntry = PolyTraumaManager.SelectByID(trauma_id);
                    if (polyTraumEntry != null)
                    {
                        polyTraumEntry.INACTIVE_FLAG = false;
                        polyTraumEntry.INACTIVE_DATE = null;
                        PolyTraumaManager.Update(polyTraumEntry);

                        GridViewPolyTraumaEntries.DataBind();
                    }
                }
            }
        }
        catch //(Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, "AdminListInactive", "100003", "btnRestore_Click()");
        }
    }
}
